#ifndef KERNEL_LIST
#define KERNEL_LIST

#include "rgb_to_grayscale_acf.h"
#include "gauss_3x3_acf.h"
#include "fast9_acf.h"
#include "nms_acf.h"
#include "dilate_diamond_acf.h"
#include "saturate_nonzero_acf.h"
#include "mark_color_channel_acf.h"

KERNEL_INFO kernelInfoConcat(RGB_TO_GRAY_K)(
 "apu_rgb_to_grayscale", 2,
	__port(__index(0),
          __identifier("INPUT_0"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(3, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUTPUT_0"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));


KERNEL_INFO kernelInfoConcat(GAUSS_3x3_K)(
 "apu_gauss_3x3", 2,
	__port(__index(0),
          __identifier("INPUT_0"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(1,1,1,1),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUTPUT_0"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));

KERNEL_INFO kernelInfoConcat(FAST9_K)(
 "apu_fast9", 3,
	__port(__index(0),
          __identifier("IN_Img"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(3,3,3,3),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUT_Img"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(2),
          __identifier("IN_Thr"),
          __attributes(ATTR_IN|ATTR_DMEM|ATTR_STATIC|ATTR_FIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));


KERNEL_INFO kernelInfoConcat(NMS_K)(
 "apu_nms", 2,
	__port(__index(0),
          __identifier("INPUT_0"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(1,1,1,1),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUTPUT_0"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));

KERNEL_INFO kernelInfoConcat(DILATE_DIAMOND_K)(
 "apu_dilate_diamond", 2,
	__port(__index(0),
          __identifier("INPUT_0"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(2,2,2,2),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUTPUT_0"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));

KERNEL_INFO kernelInfoConcat(SAT_NONZERO_K)(
 "apu_saturate_nonzero", 2,
	__port(__index(0),
          __identifier("INPUT_0"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("OUTPUT_0"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)));

KERNEL_INFO kernelInfoConcat(MARK_COL_K)(
 "apu_mark_color_channel", 4,
	__port(__index(0),
          __identifier("INPUT_IMAGE"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(3, 1),
          __ek_size(1, 1)),
	__port(__index(1),
          __identifier("INPUT_MARKER"),
          __attributes(ATTR_IN|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(2),
          __identifier("INPUT_CHANNEL_INDEX"),
          __attributes(ATTR_IN|ATTR_DMEM|ATTR_STATIC|ATTR_FIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(1, 1),
          __ek_size(1, 1)),
	__port(__index(3),
          __identifier("OUTPUT"),
          __attributes(ATTR_OUT|ATTR_CMEM|ATTR_NONSTATIC|ATTR_NONFIXED|ATTR_REG),
          __spatial_dep(0,0,0,0),
          __e0_data_type(d08u),
          __e0_size(3, 1),
          __ek_size(1, 1)));

#endif
